/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.reporting.TimingAnalysisReport;

import com.quantumdata.sam.Formats.VideoIDCode;
import com.quantumdata.sam.MainGui;
import com.quantumdata.sam.SignalAnalysisModule;
import com.quantumdata.sam.reporting.TimingAnalysisReport.ReportSaveFilter;
import com.quantumdata.sam.reporting.TimingAnalysisReport.Result;
import com.quantumdata.sam.reporting.TimingAnalysisReport.TestResults;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class TimingAnalysisReportGenerator {
    public static void generateReport(File file, ReportSaveFilter reportSaveFilter, TestResults testResults) {
        Result result;
        int n;
        PrintWriter printWriter;
        File file2;
        Object object;
        testResults.setSourceDeviceType(MainGui.getSourceDeviceTypeTextField().getText());
        testResults.setSourceDeviceMake(MainGui.getSourceDeviceMakeTextField().getText());
        testResults.setSourceDeviceModel(MainGui.getSourceDeviceModelTextField().getText());
        testResults.setSourceDeviceSerialNumber(MainGui.getSourceDeviceSerialNumberTextField().getText());
        testResults.setSourceDeviceHdmiPort((String)MainGui.getHDMIPortComboBox().getSelectedItem());
        Date date = Calendar.getInstance().getTime();
        testResults.setDate(DateFormat.getDateInstance(2).format(date));
        testResults.setTime(DateFormat.getTimeInstance(2).format(date));
        RemoteInstrument remoteInstrument = SignalAnalysisModule.ri;
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("*idn?");
        testResults.setGeneratorId(!instrumentResponse.isError() ? instrumentResponse.getResponse() : "");
        instrumentResponse = remoteInstrument.sendCmd("VERG?");
        testResults.setGeneratorGatewareVersion(!instrumentResponse.isError() ? instrumentResponse.getResponse() : "");
        testResults.setPresentUsingHdmi(MainGui.getTimingAnalyzerMeasuredDataTable().isHdmiCTSDisplayFilterMode() ? "1" : "0");
        String[] stringArray = new String[testResults.getResult().size()];
        for (int i = 0; i < testResults.getResult().size(); ++i) {
            object = testResults.getResult().get(i);
            stringArray[i] = ((Result)object).getDvic();
            ((Result)object).setDvic(VideoIDCode.getDvicString(Integer.parseInt(((Result)object).getDvic())));
        }
        try {
            file2 = new File(TimingAnalysisReportGenerator.getXMLPathName(file));
            object = new FileOutputStream(file2);
            printWriter = new PrintWriter((OutputStream)object, true);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            printWriter.println("<test_results>");
            printWriter.println("  <date>" + testResults.getDate() + "</date>");
            printWriter.println("  <time>" + testResults.getTime() + "</time>");
            printWriter.println("  <generator_id>" + testResults.getGeneratorId() + "</generator_id>");
            printWriter.println("  <generator_gateware_version>" + testResults.getGeneratorGatewareVersion() + "</generator_gateware_version>");
            printWriter.println("  <source_device_type>" + testResults.getSourceDeviceType() + "</source_device_type>");
            printWriter.println("  <source_device_make>" + testResults.getSourceDeviceMake() + "</source_device_make>");
            printWriter.println("  <source_device_model>" + testResults.getSourceDeviceModel() + "</source_device_model>");
            printWriter.println("  <source_device_serial_number>" + testResults.getSourceDeviceSerialNumber() + "</source_device_serial_number>");
            printWriter.println("  <source_device_hdmi_port>" + testResults.getSourceDeviceHdmiPort() + "</source_device_hdmi_port>");
            printWriter.println("  <present_using_hdmi>" + testResults.getPresentUsingHdmi() + "</present_using_hdmi>");
            for (n = 0; n < testResults.getResult().size(); ++n) {
                result = testResults.getResult().get(n);
                printWriter.println("  <result>");
                printWriter.println("    <testnumber>" + result.getTestnumber() + "</testnumber>");
                printWriter.println("    <perfect_match>" + result.getPerfectMatch() + "</perfect_match>");
                printWriter.println("    <test_status>" + result.getTestStatus() + "</test_status>");
                printWriter.println("    <closest_format>" + result.getClosestFormat() + "</closest_format>");
                printWriter.println("    <hdmi_spec_format_name>" + result.getHdmiSpecFormatName() + "</hdmi_spec_format_name>");
                printWriter.println("    <dvic>" + result.getDvic() + "</dvic>");
                printWriter.println("    <scan>" + result.getScan() + "</scan>");
                printWriter.println("    <hspp>" + result.getHspp() + "</hspp>");
                printWriter.println("    <vspp>" + result.getVspp() + "</vspp>");
                printWriter.println("    <vtot>" + result.getVtot() + "</vtot>");
                printWriter.println("    <htot>" + result.getHtot() + "</htot>");
                printWriter.println("    <hres>" + result.getHres() + "</hres>");
                printWriter.println("    <vres>" + result.getVres() + "</vres>");
                printWriter.println("    <hspd>" + result.getHspd() + "</hspd>");
                printWriter.println("    <vspd>" + result.getVspd() + "</vspd>");
                printWriter.println("    <hspw>" + result.getHspw() + "</hspw>");
                printWriter.println("    <vspw>" + result.getVspd() + "</vspw>");
                printWriter.println("    <hvpd>" + result.getHvpd() + "</hvpd>");
                printWriter.println("    <hrat>" + result.getHrat() + "</hrat>");
                printWriter.println("    <frat>" + result.getFrat() + "</frat>");
                printWriter.println("    <prat>" + result.getPrat() + "</prat>");
                printWriter.println("    <format_scan>" + result.getFormatScan() + "</format_scan>");
                printWriter.println("    <format_hspp>" + result.getFormatHspp() + "</format_hspp>");
                printWriter.println("    <format_vspp>" + result.getFormatVspp() + "</format_vspp>");
                printWriter.println("    <format_vtot>" + result.getFormatVtot() + "</format_vtot>");
                printWriter.println("    <format_htot>" + result.getFormatHtot() + "</format_htot>");
                printWriter.println("    <format_hres>" + result.getFormatHres() + "</format_hres>");
                printWriter.println("    <format_vres>" + result.getFormatVres() + "</format_vres>");
                printWriter.println("    <format_hspd>" + result.getFormatHspd() + "</format_hspd>");
                printWriter.println("    <format_vspd>" + result.getFormatVspd() + "</format_vspd>");
                printWriter.println("    <format_hspw>" + result.getFormatHspw() + "</format_hspw>");
                printWriter.println("    <format_vspw>" + result.getFormatVspw() + "</format_vspw>");
                printWriter.println("    <format_hvpd>" + result.getFormatHvpd() + "</format_hvpd>");
                printWriter.println("    <format_hrat>" + result.getFormatHrat() + "</format_hrat>");
                printWriter.println("    <format_frat>" + result.getFormatFrat() + "</format_frat>");
                printWriter.println("    <format_prat>" + result.getFormatPrat() + "</format_prat>");
                printWriter.println("  </result>");
            }
            printWriter.println("</test_results>");
            ((FileOutputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (reportSaveFilter.generateHtmlFile()) {
            try {
                file2 = new File(TimingAnalysisReportGenerator.getHTMLPathName(file));
                object = new FileOutputStream(file2);
                printWriter = new PrintWriter((OutputStream)object, true);
                printWriter.println("<html>");
                printWriter.println("  <head>");
                printWriter.println("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                printWriter.println("    <title>HDMI Timing Analysis Report</title>");
                printWriter.println("    <style>");
                printWriter.println("      table{FONT-WEIGHT: bold; FONT-SIZE: 10px; COLOR: #000000; FONT-FAMILY: Verdana, Arial, Helvetica, sans-serif}");
                printWriter.println("      th.bordered{border-bottom: 1px solid black; color: white; background: #666666}");
                printWriter.println("      td.bordered_left{border-left: 1px solid black;}");
                printWriter.println("      td.bordered_left_bottom{border-left: 1px solid black; border-bottom: 1px solid black;}");
                printWriter.println("      td.bordered_bottom{border-bottom: 1px solid black;}");
                printWriter.println("      td.bordered_left_bottom_right{border-left: 1px solid black; border-bottom: 1px solid black; border-right: 1px solid black}");
                printWriter.println("      td.bordered_around{border: 1px solid black;}");
                printWriter.println("    </style>");
                printWriter.println("  </head>");
                printWriter.println("  <body bgcolor=\"white\">");
                printWriter.println("    <table border=\"0\" cellspacing=\"0\">");
                printWriter.println("      <tr>");
                printWriter.println("        <td rowspan=\"2\"><img src=\"http://" + SignalAnalysisModule.generatorIP + "/images/logo_quantumdata.gif\"></td>");
                printWriter.println("        <td align=\"left\"><h3>HDMI Timing Analysis Report</h3></td>");
                printWriter.println("        <td align=\"right\">");
                printWriter.println("          <table>");
                printWriter.println("            <tr><td>Date</td><td>" + testResults.getDate() + "</td></tr>");
                printWriter.println("            <tr><td>Time</td><td>" + testResults.getTime() + "</td></tr>");
                printWriter.println("          </table>");
                printWriter.println("        </td>");
                printWriter.println("      </tr>");
                printWriter.println("      <tr>");
                printWriter.println("        <td class=\"bordered_around\" colspan=\"2\">");
                printWriter.println("          <table border=\"0\" cellspacing=\"0\">");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">Generator ID</td>");
                printWriter.println("              <td class=\"bordered_left\">" + testResults.getGeneratorId() + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">Gateware</td>");
                printWriter.println("              <td class=\"bordered_left\">" + testResults.getGeneratorGatewareVersion() + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">DUT Type</td>");
                printWriter.println("              <td class=\"bordered_left\">" + (testResults.getSourceDeviceType().equals("") ? "&nbsp;" : testResults.getSourceDeviceType()) + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">DUT Make</td>");
                printWriter.println("              <td class=\"bordered_left\">" + (testResults.getSourceDeviceMake().equals("") ? "&nbsp;" : testResults.getSourceDeviceMake()) + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">DUT Model</td>");
                printWriter.println("              <td class=\"bordered_left\">" + (testResults.getSourceDeviceModel().equals("") ? "&nbsp;" : testResults.getSourceDeviceModel()) + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">DUT Serial Number</td>");
                printWriter.println("              <td class=\"bordered_left\">" + (testResults.getSourceDeviceSerialNumber().equals("") ? "&nbsp;" : testResults.getSourceDeviceSerialNumber()) + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("            <tr>");
                printWriter.println("              <td align=\"left\">HDMI Input</td>");
                printWriter.println("              <td class=\"bordered_left\">" + (testResults.getSourceDeviceHdmiPort().equals("") ? "&nbsp;" : testResults.getSourceDeviceHdmiPort()) + "</td>");
                printWriter.println("            </tr>");
                printWriter.println("          </table>");
                printWriter.println("        </td>");
                printWriter.println("      </tr>");
                printWriter.println("    </table>");
                printWriter.println("    <p></p><p></p><p></p><p></p>");
                printWriter.println("    <table border=\"0\" cellspacing=\"0\" cellpadding=\"4\">");
                for (n = 0; n < testResults.getResult().size(); ++n) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    result = testResults.getResult().get(n);
                    if (n % 10 == 0) {
                        TimingAnalysisReportGenerator.printHeader(testResults, printWriter);
                    }
                    if (testResults.getPresentUsingHdmi().equals("0")) {
                        if (result.getPerfectMatch().equals("1")) {
                            printWriter.println("<tr>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getTestnumber());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getDvic());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getClosestFormat());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getHtot());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getHres());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getHspd());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getHspw());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getHspp());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getHvpd());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getVtot());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getVres());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getVspd());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getVspw());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getVspp());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getScan());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" align=\"center\">");
                            printWriter.println("    " + result.getFrat());
                            printWriter.println("  </td>");
                            printWriter.println("  <td class=\"bordered_bottom\" bgcolor=\"#00ff00\" valign=\"middle\" align=\"center\">");
                            printWriter.println("    PASS");
                            printWriter.println("  </td>");
                            printWriter.println("</tr>");
                            continue;
                        }
                        printWriter.println("<tr>");
                        printWriter.println("<td class=\"bordered_bottom\" align=\"center\" valign=\"middle\" rowspan=\"2\">");
                        printWriter.println(result.getTestnumber());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" align=\"center\" valign=\"middle\" rowspan=\"2\">");
                        printWriter.println(result.getDvic());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" align=\"center\" valign=\"middle\" rowspan=\"2\">");
                        printWriter.println(result.getClosestFormat());
                        printWriter.println("</td>");
                        if (result.getHtot().equals(result.getFormatHtot())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getHtot());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getHtot());
                            printWriter.println("</td>");
                        }
                        if (result.getHres().equals(result.getFormatHres())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getHres());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getHres());
                            printWriter.println("</td>");
                        }
                        if (result.getHspd().equals(result.getFormatHspd())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getHspd());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getHspd());
                            printWriter.println("</td>");
                        }
                        if (result.getHspw().equals(result.getFormatHspw())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getHspw());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getHspw());
                            printWriter.println("</td>");
                        }
                        if (result.getHspp().equals(result.getFormatHspp())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getHspp());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getHspp());
                            printWriter.println("</td>");
                        }
                        if (result.getHvpd().equals(result.getFormatHvpd())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getHvpd());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getHvpd());
                            printWriter.println("</td>");
                        }
                        if (result.getVtot().equals(result.getFormatVtot())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getVtot());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getVtot());
                            printWriter.println("</td>");
                        }
                        if (result.getVres().equals(result.getFormatVres())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getVres());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getVres());
                            printWriter.println("</td>");
                        }
                        if (result.getVspd().equals(result.getFormatVspd())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getVspd());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getVspd());
                            printWriter.println("</td>");
                        }
                        if (result.getVspw().equals(result.getFormatVspw())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getVspw());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getVspw());
                            printWriter.println("</td>");
                        }
                        if (result.getVspp().equals(result.getFormatVspp())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getVspp());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getVspp());
                            printWriter.println("</td>");
                        }
                        if (result.getScan().equals(result.getFormatScan())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getScan());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getScan());
                            printWriter.println("</td>");
                        }
                        if (result.getFrat().equals(result.getFormatFrat())) {
                            printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println(result.getFrat());
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td bgcolor=\"#fdb823\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFrat());
                            printWriter.println("</td>");
                        }
                        if (result.getTestStatus().equals("FAIL")) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println("FAIL");
                            printWriter.println("</td>");
                        } else {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"#00ff00\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                            printWriter.println("PASS");
                            printWriter.println("</td>");
                        }
                        printWriter.println("</tr>");
                        printWriter.println("<tr>");
                        if (!result.getHtot().equals(result.getFormatHtot())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatHtot());
                            printWriter.println("</td>");
                        }
                        if (!result.getHres().equals(result.getFormatHres())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatHres());
                            printWriter.println("</td>");
                        }
                        if (!result.getHspd().equals(result.getFormatHspd())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatHspd());
                            printWriter.println("</td>");
                        }
                        if (!result.getHspw().equals(result.getFormatHspw())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatHspw());
                            printWriter.println("</td>");
                        }
                        if (!result.getHspp().equals(result.getFormatHspp())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatHspp());
                            printWriter.println("</td>");
                        }
                        if (!result.getHvpd().equals(result.getFormatHvpd())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatHvpd());
                            printWriter.println("</td>");
                        }
                        if (!result.getVtot().equals(result.getFormatVtot())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatVtot());
                            printWriter.println("</td>");
                        }
                        if (!result.getVres().equals(result.getFormatVres())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatVres());
                            printWriter.println("</td>");
                        }
                        if (!result.getVspd().equals(result.getFormatVspd())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatVspd());
                            printWriter.println("</td>");
                        }
                        if (!result.getVspw().equals(result.getFormatVspw())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatVspw());
                            printWriter.println("</td>");
                        }
                        if (!result.getVspp().equals(result.getFormatVspp())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatVspp());
                            printWriter.println("</td>");
                        }
                        if (!result.getScan().equals(result.getFormatScan())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatScan());
                            printWriter.println("</td>");
                        }
                        if (!result.getFrat().equals(result.getFormatFrat())) {
                            printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"#fdb823\" valign=\"middle\" align=\"center\">");
                            printWriter.println(result.getFormatFrat());
                            printWriter.println("</td>");
                        }
                        printWriter.println("</tr>");
                        continue;
                    }
                    if (result.getPerfectMatch().equals("1")) {
                        printWriter.println("<tr>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getTestnumber());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getDvic());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHdmiSpecFormatName());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(new DecimalFormat("00.000").format(Double.parseDouble(result.getPrat()) / 1000000.0));
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHtot());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHres());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHspd());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHspw());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(Double.parseDouble(result.getVtot()) / Double.parseDouble(result.getScan()));
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(Double.parseDouble(result.getVres()) / Double.parseDouble(result.getScan()));
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        if (Integer.parseInt(result.getVtot()) % 2 == 0) {
                            n5 = Integer.parseInt(result.getVtot());
                            n4 = Integer.parseInt(result.getScan());
                            n3 = Integer.parseInt(result.getVres());
                            n2 = Integer.parseInt(result.getVspd());
                            printWriter.println(n5 / n4 - n3 / n4 - n2);
                        } else {
                            n5 = Integer.parseInt(result.getVtot());
                            n4 = Integer.parseInt(result.getScan());
                            n3 = Integer.parseInt(result.getVres());
                            n2 = Integer.parseInt(result.getVspd());
                            printWriter.println((n5 - n4 + 1) / n4 - n3 / n4 - n2);
                        }
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getVspw());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getVspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHvpd());
                        printWriter.println("</td>");
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"#00ff00\" valign=\"middle\" align=\"center\">");
                        printWriter.println("PASS");
                        printWriter.println("</td>");
                        printWriter.println("</tr>");
                        continue;
                    }
                    printWriter.println("<tr>");
                    printWriter.println("<td class=\"bordered_bottom\" align=\"center\" rowspan=\"2\">");
                    printWriter.println(result.getTestnumber());
                    printWriter.println("</td>");
                    printWriter.println("<td class=\"bordered_bottom\" align=\"center\" rowspan=\"2\">");
                    printWriter.println(result.getDvic());
                    printWriter.println("</td>");
                    printWriter.println("<td class=\"bordered_bottom\" align=\"center\" rowspan=\"2\">");
                    printWriter.println(result.getHdmiSpecFormatName());
                    printWriter.println("</td>");
                    if (!result.getPrat().equals(result.getFormatPrat())) {
                        printWriter.println("<td bgcolor=\"#fdb823\" align=\"center\">");
                        printWriter.println(new DecimalFormat("00.000").format(Double.parseDouble(result.getPrat()) / 1000000.0));
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(new DecimalFormat("00.000").format(Double.parseDouble(result.getPrat()) / 1000000.0));
                        printWriter.println("</td>");
                    }
                    if (!result.getHtot().equals(result.getFormatHtot())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHtot());
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getHtot());
                        printWriter.println("</td>");
                    }
                    if (!result.getHres().equals(result.getFormatHres())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHres());
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getHres());
                        printWriter.println("</td>");
                    }
                    if (!result.getHspd().equals(result.getFormatHspd())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHspd());
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getHspd());
                        printWriter.println("</td>");
                    }
                    if (!result.getHspp().equals(result.getFormatHspp())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getHspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                    }
                    if (!result.getHspw().equals(result.getFormatHspw())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHspw());
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getHspw());
                        printWriter.println("</td>");
                    }
                    if (!result.getVtot().equals(result.getFormatVtot()) || !result.getScan().equals(result.getFormatScan())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(Integer.parseInt(result.getVtot()) / Integer.parseInt(result.getScan()));
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(Integer.parseInt(result.getVtot()) / Integer.parseInt(result.getScan()));
                        printWriter.println("</td>");
                    }
                    if (!result.getVres().equals(result.getFormatVres()) || !result.getScan().equals(result.getFormatScan())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(Integer.parseInt(result.getVres()) / Integer.parseInt(result.getScan()));
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(Integer.parseInt(result.getVres()) / Integer.parseInt(result.getScan()));
                        printWriter.println("</td>");
                    }
                    if (!(result.getVtot().equals(result.getFormatVtot()) && result.getScan().equals(result.getFormatScan()) && result.getVres().equals(result.getFormatVres()) && result.getVspd().equals(result.getFormatVspd()))) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        if (Integer.parseInt(result.getVtot()) % 2 == 0) {
                            n5 = Integer.parseInt(result.getVtot());
                            n4 = Integer.parseInt(result.getScan());
                            n3 = Integer.parseInt(result.getVres());
                            n2 = Integer.parseInt(result.getVspd());
                            printWriter.println(n5 / n4 - n3 / n4 - n2);
                        } else {
                            n5 = Integer.parseInt(result.getVtot());
                            n4 = Integer.parseInt(result.getScan());
                            n3 = Integer.parseInt(result.getVres());
                            n2 = Integer.parseInt(result.getVspd());
                            printWriter.println((n5 - n4 + 1) / n4 - n3 / n4 - n2);
                        }
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        if (Integer.parseInt(result.getVtot()) % 2 == 0) {
                            n5 = Integer.parseInt(result.getVtot());
                            n4 = Integer.parseInt(result.getScan());
                            n3 = Integer.parseInt(result.getVres());
                            n2 = Integer.parseInt(result.getVspd());
                            printWriter.println(n5 / n4 - n3 / n4 - n2);
                        } else {
                            n5 = Integer.parseInt(result.getVtot());
                            n4 = Integer.parseInt(result.getScan());
                            n3 = Integer.parseInt(result.getVres());
                            n2 = Integer.parseInt(result.getVspd());
                            printWriter.println((n5 - n4 + 1) / n4 - n3 / n4 - n2);
                        }
                        printWriter.println("</td>");
                    }
                    if (!result.getVspw().equals(result.getFormatVspw())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getVspw());
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getVspw());
                        printWriter.println("</td>");
                    }
                    if (!result.getVspp().equals(result.getFormatVspp())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getVspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getVspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                    }
                    if (!result.getHvpd().equals(result.getFormatHvpd())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getHvpd());
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println(result.getHvpd());
                        printWriter.println("</td>");
                    }
                    if (result.getTestStatus().equals("FAIL")) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println("FAIL");
                        printWriter.println("</td>");
                    } else {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"#00ff00\" valign=\"middle\" align=\"center\" rowspan=\"2\">");
                        printWriter.println("PASS");
                        printWriter.println("</td>");
                    }
                    printWriter.println("</tr>");
                    printWriter.println("<tr>");
                    if (!result.getPrat().equals(result.getFormatPrat())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"#fdb823\" align=\"center\">");
                        printWriter.println(new DecimalFormat("00.000").format(Double.parseDouble(result.getFormatPrat()) / 1000000.0));
                        printWriter.println("</td>");
                    }
                    if (!result.getHtot().equals(result.getFormatHtot())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatHtot());
                        printWriter.println("</td>");
                    }
                    if (!result.getHres().equals(result.getFormatHres())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatHres());
                        printWriter.println("</td>");
                    }
                    if (!result.getHspd().equals(result.getFormatHspd())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatHspd());
                        printWriter.println("</td>");
                    }
                    if (!result.getHspp().equals(result.getFormatHspp())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatHspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                    }
                    if (!result.getHspw().equals(result.getFormatHspw())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatHspw());
                        printWriter.println("</td>");
                    }
                    if (!result.getVtot().equals(result.getFormatVtot()) || !result.getScan().equals(result.getFormatScan())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(Integer.parseInt(result.getFormatVtot()) / Integer.parseInt(result.getFormatScan()));
                        printWriter.println("</td>");
                    }
                    if (!result.getVres().equals(result.getFormatVres()) || !result.getScan().equals(result.getFormatScan())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(Integer.parseInt(result.getFormatVres()) / Integer.parseInt(result.getScan()));
                        printWriter.println("</td>");
                    }
                    if (!(result.getVtot().equals(result.getFormatVtot()) && result.getScan().equals(result.getFormatScan()) && result.getVres().equals(result.getFormatVres()) && result.getVspd().equals(result.getFormatVspd()))) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        if (Integer.parseInt(result.getFormatVtot()) % 2 == 0) {
                            n5 = Integer.parseInt(result.getFormatVtot());
                            n4 = Integer.parseInt(result.getFormatScan());
                            n3 = Integer.parseInt(result.getFormatVres());
                            n2 = Integer.parseInt(result.getFormatVspd());
                            printWriter.println(n5 / n4 - n3 / n4 - n2);
                        } else {
                            n5 = Integer.parseInt(result.getFormatVtot());
                            n4 = Integer.parseInt(result.getFormatScan());
                            n3 = Integer.parseInt(result.getFormatVres());
                            n2 = Integer.parseInt(result.getFormatVspd());
                            printWriter.println((n5 - n4 + 1) / n4 - n3 / n4 - n2);
                        }
                        printWriter.println("</td>");
                    }
                    if (!result.getVspw().equals(result.getFormatVspw())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatVspw());
                        printWriter.println("</td>");
                    }
                    if (!result.getVspp().equals(result.getFormatVspp())) {
                        printWriter.println("<td bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatVspp().equals("1") ? "+" : "-");
                        printWriter.println("</td>");
                    }
                    if (!result.getHvpd().equals(result.getFormatHvpd())) {
                        printWriter.println("<td class=\"bordered_bottom\" bgcolor=\"red\" valign=\"middle\" align=\"center\">");
                        printWriter.println(result.getFormatHvpd());
                        printWriter.println("</td>");
                    }
                    printWriter.println("</tr>");
                }
                printWriter.println("    </table>");
                printWriter.println("  </body>");
                printWriter.println("</html>");
                ((FileOutputStream)object).close();
                String string = "rundll32 url.dll,FileProtocolHandler file://" + file2.getPath();
                Runtime.getRuntime().exec(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (reportSaveFilter.generateExcelFile()) {
                try {
                    file2 = new File(TimingAnalysisReportGenerator.getExcelPathName(file));
                    object = new FileOutputStream(file2);
                    ((FileOutputStream)object).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            for (int i = 0; i < testResults.getResult().size(); ++i) {
                object = testResults.getResult().get(i);
                ((Result)object).setDvic(stringArray[i]);
            }
        }
    }

    private static void printHeader(TestResults testResults, PrintWriter printWriter) {
        printWriter.println("      <tr>");
        if (testResults.getPresentUsingHdmi().equals("0")) {
            printWriter.println("<th class=\"bordered\">TEST NUMBER</th>");
            printWriter.println("<th class=\"bordered\">DVIC</th>");
            printWriter.println("<th class=\"bordered\">NAME</th>");
            printWriter.println("<th class=\"bordered\">HTOT</th>");
            printWriter.println("<th class=\"bordered\">HRES</th>");
            printWriter.println("<th class=\"bordered\">HSPD</th>");
            printWriter.println("<th class=\"bordered\">HSPW</th>");
            printWriter.println("<th class=\"bordered\">HSPP</th>");
            printWriter.println("<th class=\"bordered\">HVPD</th>");
            printWriter.println("<th class=\"bordered\">VTOT</th>");
            printWriter.println("<th class=\"bordered\">VRES</th>");
            printWriter.println("<th class=\"bordered\">VSPD</th>");
            printWriter.println("<th class=\"bordered\">VSPW</th>");
            printWriter.println("<th class=\"bordered\">VSPP</th>");
            printWriter.println("<th class=\"bordered\">SCAN</th>");
            printWriter.println("<th class=\"bordered\">FRAT</th>");
            printWriter.println("<th class=\"bordered\">RESULT</th>");
        } else {
            printWriter.println("<th class=\"bordered\">TEST NUMBER</th>");
            printWriter.println("<th class=\"bordered\">VIDEO CODE</th>");
            printWriter.println("<th class=\"bordered\">FORMAT</th>");
            printWriter.println("<th class=\"bordered\">PIXEL CLOCK (MHZ)</th>");
            printWriter.println("<th class=\"bordered\">H_TOTAL</th>");
            printWriter.println("<th class=\"bordered\">H_ACTIVE</th>");
            printWriter.println("<th class=\"bordered\">VIDEO_TO_HS</th>");
            printWriter.println("<th class=\"bordered\">HS_POLARITY</th>");
            printWriter.println("<th class=\"bordered\">HS_LEN</th>");
            printWriter.println("<th class=\"bordered\">V_TOTAL</th>");
            printWriter.println("<th class=\"bordered\">V_ACTIVE</th>");
            printWriter.println("<th class=\"bordered\">VS_TO_VIDEO</th>");
            printWriter.println("<th class=\"bordered\">VS_LEN</th>");
            printWriter.println("<th class=\"bordered\">VS_POLARITY</th>");
            printWriter.println("<th class=\"bordered\">HV_OFFSET</th>");
            printWriter.println("<th class=\"bordered\">RESULT</th>");
        }
        printWriter.println("      </tr>");
    }

    private static String getExcelPathName(File file) {
        return file.getParent() + File.separator + TimingAnalysisReportGenerator.getFileBaseName(file) + ".xls";
    }

    private static String getHTMLPathName(File file) {
        return file.getParent() + File.separator + TimingAnalysisReportGenerator.getFileBaseName(file) + ".html";
    }

    private static String getXMLPathName(File file) {
        return file.getParent() + File.separator + TimingAnalysisReportGenerator.getFileBaseName(file) + ".xml";
    }

    private static String getFileBaseName(File file) {
        String string = file.getName();
        if (string.lastIndexOf(46) != -1) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        return string;
    }
}

